#include <iostream>
#include <cstdio>
#include <cstdlib>
#include <cmath>
#include <ctime>
#include <cstring>
#include <cassert>
#include <algorithm>
#include <vector>
#include <set>
#include <map>
#include <bitset>
#include <stack>
#include <queue>
#include <deque>
#include <complex>

using namespace std;

#define pb push_back
#define mp make_pair
#define sz(s) int((s).size())
#define len(s) int((s).size())
#define all(s) (s).begin(), (s).end()
#ifdef _WIN32
#define LLD "%I64d"
#else
#define LLD "%lld"
#endif
#ifdef LOCAL42
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#else
#define eprintf(...) 42
#endif
#define y0 yy0
#define y1 yy1
#define next _next
#define prev _prev
#define rank _rank
#define link _link
#define hash _hash
#define fs first
#define sc second

typedef long long ll;
typedef long long llong;
typedef long long int64;
typedef unsigned int uint;
typedef long double ld;
typedef unsigned long long ull;
typedef unsigned long long ullong;
typedef unsigned long long lint;
typedef pair<int, int> pii;
typedef vector<int> vi;

const int inf = int(1e9);
const double eps = 1e-9;
const double pi = 4 * atan(double(1));
const int N = 2020;

int n, m, good_edges;
ll ans;
bool used[N];
vector<pii> g[N];
vi lst[N], sons[N];
int ex_h[N], p[N];
int h[N], min_h[N], only_h[N];
int cnt[N][N];

void dfs1(int v, int pe, int ch) {
	h[v] = ch;
	used[v] = true;
	min_h[v] = inf;
	only_h[v] = inf;
	for (int i = 0; i < sz(g[v]); ++i) {
		if (g[v][i].sc == pe) {
			continue;
		}
		if (!used[g[v][i].fs]) {
			dfs1(g[v][i].fs, g[v][i].sc, ch + 1);
			sons[v].pb(g[v][i].fs);
			min_h[v] = min(min_h[v], min_h[g[v][i].fs]);
		} else {
			lst[v].pb(h[g[v][i].fs]);
			min_h[v] = min(min_h[v], h[g[v][i].fs]);
			only_h[v] = min(only_h[v], h[g[v][i].fs]);
		}
	}
	for (int i = 0; i < sz(sons[v]); ++i) {
		ex_h[sons[v][i]] = inf;
		for (int j = 0; j < sz(sons[v]); ++j) {
			if (i != j) {
				ex_h[sons[v][i]] = min(ex_h[sons[v][i]], min_h[sons[v][j]]);
			}
		}
	}
}

void dfs2(int v, int pv) {
	p[v] = pv;
	for (int i = 0; i < sz(sons[v]); ++i) {
		dfs2(sons[v][i], v);
		for (int j = 0; j < n; ++j) {
			cnt[v][j] += cnt[sons[v][i]][j];
		}
	}
	for (int i = 0; i < sz(lst[v]); ++i) {
		++cnt[v][lst[v][i]];
	}
	if (pv != -1) {
		int sum_cnt = 0, last = -1;
		for (int i = 0; i < h[v]; ++i) {
			sum_cnt += cnt[v][i];
			if (cnt[v][i] > 0) {
				last = i;
			}
		}
		if (last != -1) {
			int cur_v = pv, cur_h = h[v] - 1, cur_min_h = ex_h[v];
			while (cur_h > last) {
				cur_min_h = min(cur_min_h, only_h[cur_v]);
				if (cur_min_h >= cur_h) {
					++ans;
				}
				cur_min_h = min(cur_min_h, ex_h[cur_v]);
				cur_v = p[cur_v];
				--cur_h;
			}
		}
		if (sum_cnt == 0) {
			++good_edges;
		} else if (sum_cnt == 1) {
			++ans;
		}
	}
}

int main() {
#ifdef LOCAL42
#define TASK "E"
	freopen(TASK ".in", "r", stdin);
	freopen(TASK ".out", "w", stdout);
#else

#endif
	scanf("%d %d", &n, &m);
	for (int i = 0; i < m; ++i) {
		int a, b;
		scanf("%d %d", &a, &b);
		--a;
		--b;
		g[a].pb(mp(b, i));
		g[b].pb(mp(a, i));
	}
	dfs1(0, -1, 0);
	ans = 0;
	good_edges = 0;
	dfs2(0, -1);
	ans += good_edges * (good_edges - 1) / 2 + good_edges * (m - good_edges);
	cout << ans << endl;
	return 0;
}
